package kochModel.visitor;

import lrs.*;
import kochModel.*;
import java.awt.Graphics;
import fp.*; 

public class PaintNoParentVisitor implements IKochVisitor<Object,Graphics> {
  
  public static final PaintNoParentVisitor Singleton = new PaintNoParentVisitor();
  
  private PaintNoParentVisitor() {}
  
  private  IMapAlgo<Koch, Graphics> _mapAlgo = new IMapAlgo<Koch, Graphics>() {
    public boolean apply(Koch host, Graphics... g) {
      host.execute(PaintNoParentVisitor.this, g);
      return true;
    }
    public void noApply(Graphics... g) {
    }
  };
    
  public Object baseCase(Koch host, Graphics... g) {
    g[0].drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
                  (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));
    return null;
  }
  
  public Object inductCase(Koch host, Graphics... g) {
    host.map(_mapAlgo, g);
    return null;
  }  
}